/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.logon;

import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.logon.LogonEvent;
import com.ibm.hwmca.fw.logon.LogonListener;
import com.ibm.hwmca.fw.task.UserContext;
import java.util.ArrayList;
import java.util.Iterator;

public class LogonManager {
    private static ArrayList listeners = new ArrayList();
    private static LogonManager instance = new LogonManager();
    private Object listenersLock = new Object();

    private LogonManager() {
    }

    public static LogonManager getLogonManager() {
        return instance;
    }

    public void addLogonListener(LogonListener listener) {
        this.addLogonListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogonListener(LogonListener listener, UserContext userContext) {
        Object object = this.listenersLock;
        synchronized (object) {
            ListenerInfo l = new ListenerInfo();
            l.listener = listener;
            l.userContext = userContext;
            listeners.add(l);
        }
    }

    public void removeLogonListener(LogonListener listener) {
        this.removeLogonListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogonListener(LogonListener listener, UserContext userContext) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList listeners = (ArrayList)LogonManager.listeners.clone();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ListenerInfo next = (ListenerInfo)iterator.next();
                if (!next.listener.equals(listener) || userContext != null && (next.userContext == null || !userContext.equals(next.userContext))) continue;
                LogonManager.listeners.remove(next);
                if (userContext != null) break;
            }
        }
    }

    public static void logOn() {
        LogonManager.getLogonManager().sendEvent(1);
    }

    public static void logOff() {
        LogonManager lm = LogonManager.getLogonManager();
        lm.sendEvent(2);
        lm.logSystemEvent();
    }

    public static void disconnect() {
        LogonManager.getLogonManager().sendEvent(3);
    }

    public static void reconnect() {
        LogonManager.getLogonManager().sendEvent(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(int type) {
        ArrayList listeners;
        Object object = this.listenersLock;
        synchronized (object) {
            listeners = (ArrayList)LogonManager.listeners.clone();
        }
        UserContext currentUserContext = UserContext.getCurrentUserContext();
        LogonEvent evt = new LogonEvent(instance, type);
        evt.setUserContext(currentUserContext);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ListenerInfo l = (ListenerInfo)iterator.next();
            if (l.userContext != null && (currentUserContext == null || !currentUserContext.equals(l.userContext))) continue;
            switch (type) {
                case 1: {
                    l.listener.loggedOn(evt);
                    break;
                }
                case 2: {
                    l.listener.loggedOff(evt);
                    break;
                }
                case 3: {
                    l.listener.disconnected(evt);
                    break;
                }
                case 4: {
                    l.listener.reconnected(evt);
                }
            }
        }
    }

    private void logSystemEvent() {
        FrameworkEventText fet = new FrameworkEventText(40);
        SystemEventLog logEvent = new SystemEventLog(fet, "LOGOFF");
        logEvent.log();
        E4EventLog e4EventLog = new E4EventLog(fet, "LOGOFF");
        e4EventLog.log();
    }

    class ListenerInfo {
        LogonListener listener;
        UserContext userContext;

        ListenerInfo() {
        }
    }
}

